/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OrderBy
extends Node {
    private final List<SortItem> sortItems;

    public OrderBy(List<SortItem> sortItems) {
        this(Optional.empty(), sortItems);
    }

    public OrderBy(NodeLocation location, List<SortItem> sortItems) {
        this(Optional.of(location), sortItems);
    }

    private OrderBy(Optional<NodeLocation> location, List<SortItem> sortItems) {
        super(location);
        Objects.requireNonNull(sortItems, "sortItems is null");
        Preconditions.checkArgument((!sortItems.isEmpty() ? 1 : 0) != 0, (Object)"sortItems should not be empty");
        this.sortItems = ImmutableList.copyOf(sortItems);
    }

    public List<SortItem> getSortItems() {
        return this.sortItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOrderBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.sortItems;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortItems", this.sortItems).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy o = (OrderBy)obj;
        return Objects.equals(this.sortItems, o.sortItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sortItems);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return OrderBy.sameClass(this, other);
    }
}

