/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.fressian.handlers.ILookup;

public class CachingLookup<K, V>
implements ILookup<K, V> {
    public final ILookup<K, V> lookup;
    public final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    public final AtomicReference<V> nullKeyValue = new AtomicReference<Object>(null);

    public CachingLookup(ILookup<K, V> lookup) {
        this.lookup = lookup;
    }

    private V getNullVal() {
        V val = this.nullKeyValue.get();
        if (val != null) {
            return val;
        }
        val = this.lookup.valAt(null);
        if (val != null) {
            this.nullKeyValue.getAndSet(val);
        }
        return val;
    }

    @Override
    public V valAt(K key) {
        if (key == null) {
            return this.getNullVal();
        }
        V val = this.map.get(key);
        if (val != null) {
            return val;
        }
        val = this.lookup.valAt(key);
        if (val != null) {
            this.map.putIfAbsent(key, val);
        }
        return val;
    }
}

