/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        CreateVolumePermissionModifications createVolumePermission;
        SdkInternalList groupNamesList;
        SdkInternalList userIdsList;
        if (modifySnapshotAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.getOperationType()));
        }
        if (!(userIdsList = (SdkInternalList)modifySnapshotAttributeRequest.getUserIds()).isEmpty() || !userIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (Object userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!(groupNamesList = (SdkInternalList)modifySnapshotAttributeRequest.getGroupNames()).isEmpty() || !groupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission()) != null) {
            SdkInternalList removeList;
            SdkInternalList addList = (SdkInternalList)createVolumePermission.getAdd();
            if (!addList.isEmpty() || !addList.isAutoConstruct()) {
                int addListIndex = 1;
                for (CreateVolumePermission addListValue : addList) {
                    if (addListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)addListValue.getUserId()));
                    }
                    if (addListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)addListValue.getGroup()));
                    }
                    ++addListIndex;
                }
            }
            if (!(removeList = (SdkInternalList)createVolumePermission.getRemove()).isEmpty() || !removeList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (CreateVolumePermission removeListValue : removeList) {
                    if (removeListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)removeListValue.getUserId()));
                    }
                    if (removeListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)removeListValue.getGroup()));
                    }
                    ++removeListIndex;
                }
            }
        }
        return request;
    }
}

