/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.session.db;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class DbSessionPropertyManagerConfig {
    private String configDbUrl;
    private String username;
    private String password;
    private Duration specsRefreshPeriod = new Duration(10.0, TimeUnit.SECONDS);

    @NotNull
    public String getConfigDbUrl() {
        return this.configDbUrl;
    }

    @Config(value="session-property-manager.db.url")
    public DbSessionPropertyManagerConfig setConfigDbUrl(String configDbUrl) {
        this.configDbUrl = configDbUrl;
        return this;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Config(value="session-property-manager.db.username")
    public DbSessionPropertyManagerConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Config(value="session-property-manager.db.password")
    @ConfigSecuritySensitive
    public DbSessionPropertyManagerConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getSpecsRefreshPeriod() {
        return this.specsRefreshPeriod;
    }

    @Config(value="session-property-manager.db.refresh-period")
    public DbSessionPropertyManagerConfig setSpecsRefreshPeriod(Duration specsRefreshPeriod) {
        this.specsRefreshPeriod = specsRefreshPeriod;
        return this;
    }
}

