/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.session.db;

import com.google.common.annotations.VisibleForTesting;
import io.prestosql.plugin.session.SessionMatchSpec;
import java.util.List;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;

public interface SessionPropertiesDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS session_specs(\nspec_id BIGINT NOT NULL AUTO_INCREMENT,\nuser_regex VARCHAR(512),\nsource_regex VARCHAR(512),\nquery_type VARCHAR(512),\ngroup_regex VARCHAR(512),\npriority INT NOT NULL,\nPRIMARY KEY (spec_id)\n)")
    public void createSessionSpecsTable();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS session_client_tags(\ntag_spec_id BIGINT NOT NULL,\nclient_tag VARCHAR(512) NOT NULL,\nPRIMARY KEY (tag_spec_id, client_tag),\nFOREIGN KEY (tag_spec_id) REFERENCES session_specs (spec_id)\n)")
    public void createSessionClientTagsTable();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS session_property_values(\nproperty_spec_id BIGINT NOT NULL,\nsession_property_name VARCHAR(512),\nsession_property_value VARCHAR(512),\nPRIMARY KEY (property_spec_id, session_property_name),\nFOREIGN KEY (property_spec_id) REFERENCES session_specs (spec_id)\n)")
    public void createSessionPropertiesTable();

    @SqlUpdate(value="DROP TABLE IF EXISTS session_specs")
    public void dropSessionSpecsTable();

    @SqlUpdate(value="DROP TABLE IF EXISTS session_client_tags")
    public void dropSessionClientTagsTable();

    @SqlUpdate(value="DROP TABLE IF EXISTS session_property_values")
    public void dropSessionPropertiesTable();

    @SqlQuery(value="SELECT S.spec_id,\nS.user_regex,\nS.source_regex,\nS.query_type,\nS.group_regex,\nS.client_tags,\nGROUP_CONCAT(P.session_property_name ORDER BY P.session_property_name) session_property_names,\nGROUP_CONCAT(P.session_property_value ORDER BY P.session_property_name) session_property_values\nFROM\n(SELECT\nA.spec_id, A.user_regex, A.source_regex, A.query_type, A.group_regex, A.priority,\nGROUP_CONCAT(DISTINCT B.client_tag) client_tags\nFROM session_specs A\nLEFT JOIN session_client_tags B\nON A.spec_id = B.tag_spec_id\nGROUP BY A.spec_id, A.user_regex, A.source_regex, A.query_type, A.group_regex, A.priority)\n S JOIN\nsession_property_values P\nON S.spec_id = P.property_spec_id\nGROUP BY S.spec_id, S.user_regex, S.source_regex, S.query_type, S.group_regex, S.priority, S.client_tags\nORDER BY S.priority asc")
    @UseRowMapper(value=SessionMatchSpec.Mapper.class)
    public List<SessionMatchSpec> getSessionMatchSpecs();

    @SqlUpdate(value="INSERT INTO session_specs (spec_id, user_regex, source_regex, query_type, group_regex, priority)\nVALUES (:spec_id, :user_regex, :source_regex, :query_type, :group_regex, :priority)")
    @VisibleForTesting
    public void insertSpecRow(@Bind(value="spec_id") long var1, @Bind(value="user_regex") String var3, @Bind(value="source_regex") String var4, @Bind(value="query_type") String var5, @Bind(value="group_regex") String var6, @Bind(value="priority") int var7);

    @SqlUpdate(value="INSERT INTO session_client_tags (tag_spec_id, client_tag) VALUES (:spec_id, :client_tag)")
    @VisibleForTesting
    public void insertClientTag(@Bind(value="spec_id") long var1, @Bind(value="client_tag") String var3);

    @SqlUpdate(value="INSERT INTO session_property_values (property_spec_id, session_property_name, session_property_value)\nVALUES (:property_spec_id, :session_property_name, :session_property_value)")
    @VisibleForTesting
    public void insertSessionProperty(@Bind(value="property_spec_id") long var1, @Bind(value="session_property_name") String var3, @Bind(value="session_property_value") String var4);
}

