/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.Int96ArrayBlock;
import io.prestosql.spi.block.Int96ArrayBlockBuilder;

public class Int96ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT96_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getHighSlice(block));
            sliceOutput.writeBytes(this.getLowSlice(block));
        } else {
            long[] high = new long[positionCount];
            int[] low = new int[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                high[nonNullPositionCount] = block.getLong(i, 0);
                low[nonNullPositionCount] = block.getInt(i, 8);
                if (block.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(Slices.wrappedLongArray((long[])high, (int)0, (int)nonNullPositionCount));
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])low, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] high = new long[positionCount];
        int[] low = new int[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])high));
            sliceInput.readBytes(Slices.wrappedIntArray((int[])low));
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readBytes(Slices.wrappedLongArray((long[])high, (int)0, (int)nonNullPositionCount));
            sliceInput.readBytes(Slices.wrappedIntArray((int[])low, (int)0, (int)nonNullPositionCount));
            int position = nonNullPositionCount - 1;
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                high[i] = high[position];
                low[i] = low[position];
                if (valueIsNull[i]) continue;
                --position;
            }
        }
        return new Int96ArrayBlock(0, positionCount, valueIsNull, high, low);
    }

    private Slice getHighSlice(Block block) {
        if (block instanceof Int96ArrayBlock) {
            return ((Int96ArrayBlock)block).getHighSlice();
        }
        if (block instanceof Int96ArrayBlockBuilder) {
            return ((Int96ArrayBlockBuilder)block).getHighSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }

    private Slice getLowSlice(Block block) {
        if (block instanceof Int96ArrayBlock) {
            return ((Int96ArrayBlock)block).getLowSlice();
        }
        if (block instanceof Int96ArrayBlockBuilder) {
            return ((Int96ArrayBlockBuilder)block).getLowSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

