/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.eventlistener;

import io.prestosql.spi.eventlistener.SplitFailureInfo;
import io.prestosql.spi.eventlistener.SplitStatistics;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class SplitCompletedEvent {
    private final String queryId;
    private final String stageId;
    private final String taskId;
    private final Optional<String> catalogName;
    private final Instant createTime;
    private final Optional<Instant> startTime;
    private final Optional<Instant> endTime;
    private final SplitStatistics statistics;
    private final Optional<SplitFailureInfo> failureInfo;
    private final String payload;

    public SplitCompletedEvent(String queryId, String stageId, String taskId, Optional<String> catalogName, Instant createTime, Optional<Instant> startTime, Optional<Instant> endTime, SplitStatistics statistics, Optional<SplitFailureInfo> failureInfo, String payload) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.startTime = Objects.requireNonNull(startTime, "startTime is null");
        this.endTime = Objects.requireNonNull(endTime, "endTime is null");
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
        this.payload = Objects.requireNonNull(payload, "payload is null");
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getStageId() {
        return this.stageId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Optional<Instant> getStartTime() {
        return this.startTime;
    }

    public Optional<Instant> getEndTime() {
        return this.endTime;
    }

    public SplitStatistics getStatistics() {
        return this.statistics;
    }

    public Optional<SplitFailureInfo> getFailureInfo() {
        return this.failureInfo;
    }

    public String getPayload() {
        return this.payload;
    }

    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    public String toString() {
        return new StringJoiner(", ", SplitCompletedEvent.class.getSimpleName() + "[", "]").add("queryId='" + this.queryId + "'").add("stageId='" + this.stageId + "'").add("taskId='" + this.taskId + "'").toString();
    }
}

