/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Domain {
    public static final int DEFAULT_COMPACTION_THRESHOLD = 32;
    private final ValueSet values;
    private final boolean nullAllowed;

    private Domain(ValueSet values, boolean nullAllowed) {
        this.values = Objects.requireNonNull(values, "values is null");
        this.nullAllowed = nullAllowed;
    }

    @JsonCreator
    public static Domain create(@JsonProperty(value="values") ValueSet values, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        return new Domain(values, nullAllowed);
    }

    public static Domain none(Type type) {
        return new Domain(ValueSet.none(type), false);
    }

    public static Domain all(Type type) {
        return new Domain(ValueSet.all(type), true);
    }

    public static Domain onlyNull(Type type) {
        return new Domain(ValueSet.none(type), true);
    }

    public static Domain notNull(Type type) {
        return new Domain(ValueSet.all(type), false);
    }

    public static Domain singleValue(Type type, Object value) {
        return new Domain(ValueSet.of(type, value, new Object[0]), false);
    }

    public static Domain multipleValues(Type type, List<?> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        if (values.size() == 1) {
            return Domain.singleValue(type, values.get(0));
        }
        return new Domain(ValueSet.of(type, values.get(0), values.subList(1, values.size()).toArray()), false);
    }

    public Type getType() {
        return this.values.getType();
    }

    @JsonProperty
    public ValueSet getValues() {
        return this.values;
    }

    @JsonProperty
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public boolean isNone() {
        return this.values.isNone() && !this.nullAllowed;
    }

    public boolean isAll() {
        return this.values.isAll() && this.nullAllowed;
    }

    public boolean isSingleValue() {
        return !this.nullAllowed && this.values.isSingleValue();
    }

    public boolean isNullableSingleValue() {
        if (this.nullAllowed) {
            return this.values.isNone();
        }
        return this.values.isSingleValue();
    }

    public boolean isOnlyNull() {
        return this.values.isNone() && this.nullAllowed;
    }

    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Domain is not a single value");
        }
        return this.values.getSingleValue();
    }

    public Object getNullableSingleValue() {
        if (!this.isNullableSingleValue()) {
            throw new IllegalStateException("Domain is not a nullable single value");
        }
        if (this.nullAllowed) {
            return null;
        }
        return this.values.getSingleValue();
    }

    public boolean includesNullableValue(Object value) {
        return value == null ? this.nullAllowed : this.values.containsValue(value);
    }

    boolean isNullableDiscreteSet() {
        return this.values.isNone() ? this.nullAllowed : this.values.isDiscreteSet();
    }

    DiscreteSet getNullableDiscreteSet() {
        if (!this.isNullableDiscreteSet()) {
            throw new IllegalStateException("Domain is not a nullable discrete set");
        }
        return new DiscreteSet(this.values.isNone() ? List.of() : this.values.getDiscreteSet(), this.nullAllowed);
    }

    public boolean overlaps(Domain other) {
        this.checkCompatibility(other);
        if (this.isNullAllowed() && other.isNullAllowed()) {
            return true;
        }
        return this.values.overlaps(other.getValues());
    }

    public boolean contains(Domain other) {
        this.checkCompatibility(other);
        return this.union(other).equals(this);
    }

    public Domain intersect(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.intersect(other.getValues()), this.isNullAllowed() && other.isNullAllowed());
    }

    public Domain union(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.union(other.getValues()), this.isNullAllowed() || other.isNullAllowed());
    }

    public static Domain union(List<Domain> domains) {
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("domains cannot be empty for union");
        }
        if (domains.size() == 1) {
            return domains.get(0);
        }
        boolean nullAllowed = false;
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>(domains.size());
        for (Domain domain : domains) {
            valueSets.add(domain.getValues());
            nullAllowed = nullAllowed || domain.nullAllowed;
        }
        ValueSet unionedValues = ((ValueSet)valueSets.get(0)).union(valueSets.subList(1, valueSets.size()));
        return new Domain(unionedValues, nullAllowed);
    }

    public Domain complement() {
        return new Domain(this.values.complement(), !this.nullAllowed);
    }

    public Domain subtract(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.subtract(other.getValues()), this.isNullAllowed() && !other.isNullAllowed());
    }

    private void checkCompatibility(Domain domain) {
        if (!this.getType().equals(domain.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Domain types: %s vs %s", this.getType(), domain.getType()));
        }
        if (this.values.getClass() != domain.values.getClass()) {
            throw new IllegalArgumentException(String.format("Mismatched Domain value set classes: %s vs %s", this.values.getClass(), domain.values.getClass()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.values, this.nullAllowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        return Objects.equals(this.values, other.values) && this.nullAllowed == other.nullAllowed;
    }

    public Domain simplify() {
        return this.simplify(32);
    }

    public Domain simplify(int threshold) {
        Optional simplifiedValueSet = this.values.getValuesProcessor().transform(ranges -> {
            if (ranges.getRangeCount() <= threshold) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.ofRanges(ranges.getSpan(), new Range[0]));
        }, discreteValues -> {
            if (discreteValues.getValuesCount() <= threshold) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.all(this.values.getType()));
        }, allOrNone -> Optional.empty());
        if (simplifiedValueSet.isEmpty()) {
            return this;
        }
        return Domain.create((ValueSet)simplifiedValueSet.get(), this.nullAllowed);
    }

    public String toString() {
        return "[ " + (this.nullAllowed ? "NULL, " : "") + this.values.toString() + " ]";
    }

    public String toString(ConnectorSession session) {
        return "[ " + (this.nullAllowed ? "NULL, " : "") + this.values.toString(session) + " ]";
    }

    static class DiscreteSet {
        private final List<Object> nonNullValues;
        private final boolean containsNull;

        DiscreteSet(List<Object> values, boolean containsNull) {
            this.nonNullValues = Objects.requireNonNull(values, "values is null");
            this.containsNull = containsNull;
            if (!containsNull && values.isEmpty()) {
                throw new IllegalArgumentException("Discrete set cannot be empty");
            }
        }

        List<Object> getNonNullValues() {
            return this.nonNullValues;
        }

        boolean containsNull() {
            return this.containsNull;
        }
    }
}

