/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.util.List;

public class TimeWithTimeZoneParametricType
implements ParametricType {
    public static final TimeWithTimeZoneParametricType TIME_WITH_TIME_ZONE = new TimeWithTimeZoneParametricType();

    @Override
    public String getName() {
        return "time with time zone";
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for TIME WITH TIME ZONE");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("TIME WITH TIME ZONE precision must be a number");
        }
        long precision = parameter.getLongLiteral();
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid TIME WITH TIME ZONE precision " + precision);
        }
        return TimeWithTimeZoneType.createTimeWithTimeZoneType((int)precision);
    }
}

