/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;

public final class TimeWithTimeZoneTypes {
    private TimeWithTimeZoneTypes() {
    }

    static long normalizePicos(long picos, int offsetMinutes) {
        return Math.floorMod(picos - (long)offsetMinutes * 60000000000000L, 86400000000000000L);
    }

    static long normalizeNanos(long nanos, int offsetMinutes) {
        return Math.floorMod(nanos - (long)offsetMinutes * 60000000000L, 86400000000000L);
    }

    static long normalizePackedTime(long packedTime) {
        return TimeWithTimeZoneTypes.normalizeNanos(DateTimeEncoding.unpackTimeNanos(packedTime), DateTimeEncoding.unpackOffsetMinutes(packedTime));
    }

    static long normalize(LongTimeWithTimeZone time) {
        return Math.floorMod(time.getPicoSeconds() - (long)time.getOffsetMinutes() * 60000000000000L, 86400000000000000L);
    }
}

