/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.index;

import com.datomic.lucene.analysis.tokenattributes.CharTermAttribute;
import com.datomic.lucene.analysis.tokenattributes.OffsetAttribute;
import com.datomic.lucene.index.DocFieldConsumerPerField;
import com.datomic.lucene.index.DocFieldConsumerPerThread;
import com.datomic.lucene.index.DocFieldProcessorPerThread;
import com.datomic.lucene.index.DocInverter;
import com.datomic.lucene.index.DocInverterPerField;
import com.datomic.lucene.index.DocumentsWriter;
import com.datomic.lucene.index.FieldInfo;
import com.datomic.lucene.index.FieldInvertState;
import com.datomic.lucene.index.InvertedDocConsumerPerThread;
import com.datomic.lucene.index.InvertedDocEndConsumerPerThread;
import com.datomic.lucene.index.ReusableStringReader;
import com.datomic.lucene.util.AttributeSource;
import java.io.IOException;

final class DocInverterPerThread
extends DocFieldConsumerPerThread {
    final DocInverter docInverter;
    final InvertedDocConsumerPerThread consumer;
    final InvertedDocEndConsumerPerThread endConsumer;
    final SingleTokenAttributeSource singleToken = new SingleTokenAttributeSource();
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState = new FieldInvertState();
    final ReusableStringReader stringReader = new ReusableStringReader();

    public DocInverterPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocInverter docInverter) {
        this.docInverter = docInverter;
        this.docState = docFieldProcessorPerThread.docState;
        this.consumer = docInverter.consumer.addThread(this);
        this.endConsumer = docInverter.endConsumer.addThread(this);
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        this.endConsumer.startDocument();
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        this.endConsumer.finishDocument();
        return this.consumer.finishDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        try {
            this.consumer.abort();
            Object var2_1 = null;
            this.endConsumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endConsumer.abort();
            throw throwable;
        }
    }

    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocInverterPerField(this, fi);
    }

    static class SingleTokenAttributeSource
    extends AttributeSource {
        final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);

        private SingleTokenAttributeSource() {
        }

        public void reinit(String stringValue, int startOffset, int endOffset) {
            this.termAttribute.setEmpty().append(stringValue);
            this.offsetAttribute.setOffset(startOffset, endOffset);
        }
    }
}

