/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.index;

import com.datomic.lucene.index.DefaultSkipListWriter;
import com.datomic.lucene.index.FieldInfo;
import com.datomic.lucene.index.FieldInfos;
import com.datomic.lucene.index.FormatPostingsFieldsConsumer;
import com.datomic.lucene.index.FormatPostingsTermsConsumer;
import com.datomic.lucene.index.FormatPostingsTermsWriter;
import com.datomic.lucene.index.SegmentWriteState;
import com.datomic.lucene.index.TermInfosWriter;
import com.datomic.lucene.store.Directory;
import com.datomic.lucene.util.IOUtils;
import java.io.IOException;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPostingsFieldsWriter(SegmentWriteState state, FieldInfos fieldInfos) throws IOException {
        this.dir = state.directory;
        this.segment = state.segmentName;
        this.totalNumDocs = state.numDocs;
        this.fieldInfos = fieldInfos;
        boolean success = false;
        try {
            this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state.termIndexInterval);
            this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
            this.termsWriter = new FormatPostingsTermsWriter(state, this);
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (success) throw throwable;
            IOUtils.closeSafely(true, this.termsOut, this.termsWriter);
            throw throwable;
        }
    }

    FormatPostingsTermsConsumer addField(FieldInfo field) {
        this.termsWriter.setField(field);
        return this.termsWriter;
    }

    void finish() throws IOException {
        IOUtils.closeSafely(false, this.termsOut, this.termsWriter);
    }
}

