/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.search;

import com.datomic.lucene.search.Collector;
import com.datomic.lucene.search.Scorer;
import com.datomic.lucene.search.Weight;
import com.datomic.lucene.util.ScorerDocQueue;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DisjunctionSumScorer
extends Scorer {
    private final int nrScorers;
    protected final List<Scorer> subScorers;
    private final int minimumNrMatchers;
    private ScorerDocQueue scorerDocQueue;
    private int currentDoc = -1;
    protected int nrMatchers = -1;
    private float currentScore = Float.NaN;

    public DisjunctionSumScorer(Weight weight, List<Scorer> subScorers, int minimumNrMatchers) throws IOException {
        super(weight);
        this.nrScorers = subScorers.size();
        if (minimumNrMatchers <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.nrScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.minimumNrMatchers = minimumNrMatchers;
        this.subScorers = subScorers;
        this.initScorerDocQueue();
    }

    public DisjunctionSumScorer(Weight weight, List<Scorer> subScorers) throws IOException {
        this(weight, subScorers, 1);
    }

    private void initScorerDocQueue() throws IOException {
        this.scorerDocQueue = new ScorerDocQueue(this.nrScorers);
        for (Scorer se : this.subScorers) {
            if (se.nextDoc() == Integer.MAX_VALUE) continue;
            this.scorerDocQueue.insert(se);
        }
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while (this.nextDoc() != Integer.MAX_VALUE) {
            collector.collect(this.currentDoc);
        }
    }

    @Override
    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        collector.setScorer(this);
        while (this.currentDoc < max) {
            collector.collect(this.currentDoc);
            if (this.nextDoc() != Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers || !this.advanceAfterCurrent()) {
            this.currentDoc = Integer.MAX_VALUE;
        }
        return this.currentDoc;
    }

    protected boolean advanceAfterCurrent() throws IOException {
        do {
            this.currentDoc = this.scorerDocQueue.topDoc();
            this.currentScore = this.scorerDocQueue.topScore();
            this.nrMatchers = 1;
            while ((this.scorerDocQueue.topNextAndAdjustElsePop() || this.scorerDocQueue.size() != 0) && this.scorerDocQueue.topDoc() == this.currentDoc) {
                this.currentScore += this.scorerDocQueue.topScore();
                ++this.nrMatchers;
            }
            if (this.nrMatchers < this.minimumNrMatchers) continue;
            return true;
        } while (this.scorerDocQueue.size() >= this.minimumNrMatchers);
        return false;
    }

    @Override
    public float score() throws IOException {
        return this.currentScore;
    }

    @Override
    public int docID() {
        return this.currentDoc;
    }

    public int nrMatchers() {
        return this.nrMatchers;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers) {
            this.currentDoc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (target <= this.currentDoc) {
            return this.currentDoc;
        }
        do {
            if (this.scorerDocQueue.topDoc() < target) continue;
            return this.advanceAfterCurrent() ? this.currentDoc : (this.currentDoc = Integer.MAX_VALUE);
        } while (this.scorerDocQueue.topSkipToAndAdjustElsePop(target) || this.scorerDocQueue.size() >= this.minimumNrMatchers);
        this.currentDoc = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }
}

