/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.search;

import com.datomic.lucene.index.IndexReader;
import com.datomic.lucene.index.Term;
import com.datomic.lucene.index.TermEnum;
import com.datomic.lucene.search.FilteredTermEnum;
import com.datomic.lucene.search.MultiTermQuery;
import com.datomic.lucene.util.NumericUtils;
import com.datomic.lucene.util.StringHelper;
import com.datomic.lucene.util.ToStringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericRangeQuery<T extends Number>
extends MultiTermQuery {
    String field;
    final int precisionStep;
    final int valSize;
    final T min;
    final T max;
    final boolean minInclusive;
    final boolean maxInclusive;

    private NumericRangeQuery(String field, int precisionStep, int valSize, T min, T max, boolean minInclusive, boolean maxInclusive) {
        assert (valSize == 32 || valSize == 64);
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.field = StringHelper.intern(field);
        this.precisionStep = precisionStep;
        this.valSize = valSize;
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        switch (valSize) {
            case 64: {
                this.setRewriteMethod(precisionStep > 6 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            case 32: {
                this.setRewriteMethod(precisionStep > 8 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            default: {
                throw new IllegalArgumentException("valSize must be 32 or 64");
            }
        }
        if (min != null && min.equals(max)) {
            this.setRewriteMethod(CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        }
    }

    public static NumericRangeQuery<Long> newLongRange(String field, int precisionStep, Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Long>(field, precisionStep, 64, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Long> newLongRange(String field, Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Long>(field, 4, 64, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Integer> newIntRange(String field, int precisionStep, Integer min, Integer max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Integer>(field, precisionStep, 32, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Integer> newIntRange(String field, Integer min, Integer max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Integer>(field, 4, 32, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Double> newDoubleRange(String field, int precisionStep, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Double>(field, precisionStep, 64, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Double> newDoubleRange(String field, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Double>(field, 4, 64, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Float> newFloatRange(String field, int precisionStep, Float min, Float max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Float>(field, precisionStep, 32, min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery<Float> newFloatRange(String field, Float min, Float max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery<Float>(field, 4, 32, min, max, minInclusive, maxInclusive);
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new NumericRangeTermEnum(reader);
    }

    public String getField() {
        return this.field;
    }

    public boolean includesMin() {
        return this.minInclusive;
    }

    public boolean includesMax() {
        return this.maxInclusive;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field).append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost(this.getBoost())).toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof NumericRangeQuery) {
            NumericRangeQuery q = (NumericRangeQuery)o;
            return this.field == q.field && (q.min == null ? this.min == null : q.min.equals(this.min)) && (q.max == null ? this.max == null : q.max.equals(this.max)) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive && this.precisionStep == q.precisionStep;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int hash = super.hashCode();
        hash += this.field.hashCode() ^ 1164311910 + this.precisionStep ^ 0x64365465;
        if (this.min != null) {
            hash += this.min.hashCode() ^ 0x14FA55FB;
        }
        if (this.max != null) {
            hash += this.max.hashCode() ^ 0x733FA5FE;
        }
        return hash + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.field = StringHelper.intern(this.field);
    }

    private final class NumericRangeTermEnum
    extends FilteredTermEnum {
        private final IndexReader reader;
        private final LinkedList<String> rangeBounds = new LinkedList();
        private final Term termTemplate;
        private String currentUpperBound;

        NumericRangeTermEnum(IndexReader reader) throws IOException {
            this.termTemplate = new Term(NumericRangeQuery.this.field);
            this.currentUpperBound = null;
            this.reader = reader;
            switch (NumericRangeQuery.this.valSize) {
                case 64: {
                    long minBound = Long.MIN_VALUE;
                    if (NumericRangeQuery.this.min instanceof Long) {
                        minBound = ((Number)NumericRangeQuery.this.min).longValue();
                    } else if (NumericRangeQuery.this.min instanceof Double) {
                        minBound = NumericUtils.doubleToSortableLong(((Number)NumericRangeQuery.this.min).doubleValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (minBound == Long.MAX_VALUE) break;
                        ++minBound;
                    }
                    long maxBound = Long.MAX_VALUE;
                    if (NumericRangeQuery.this.max instanceof Long) {
                        maxBound = ((Number)NumericRangeQuery.this.max).longValue();
                    } else if (NumericRangeQuery.this.max instanceof Double) {
                        maxBound = NumericUtils.doubleToSortableLong(((Number)NumericRangeQuery.this.max).doubleValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (maxBound == Long.MIN_VALUE) break;
                        --maxBound;
                    }
                    NumericUtils.splitLongRange(new NumericUtils.LongRangeBuilder(){

                        public final void addRange(String minPrefixCoded, String maxPrefixCoded) {
                            NumericRangeTermEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, NumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                case 32: {
                    int minBound = Integer.MIN_VALUE;
                    if (NumericRangeQuery.this.min instanceof Integer) {
                        minBound = ((Number)NumericRangeQuery.this.min).intValue();
                    } else if (NumericRangeQuery.this.min instanceof Float) {
                        minBound = NumericUtils.floatToSortableInt(((Number)NumericRangeQuery.this.min).floatValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (minBound == Integer.MAX_VALUE) break;
                        ++minBound;
                    }
                    int maxBound = Integer.MAX_VALUE;
                    if (NumericRangeQuery.this.max instanceof Integer) {
                        maxBound = ((Number)NumericRangeQuery.this.max).intValue();
                    } else if (NumericRangeQuery.this.max instanceof Float) {
                        maxBound = NumericUtils.floatToSortableInt(((Number)NumericRangeQuery.this.max).floatValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (maxBound == Integer.MIN_VALUE) break;
                        --maxBound;
                    }
                    NumericUtils.splitIntRange(new NumericUtils.IntRangeBuilder(){

                        public final void addRange(String minPrefixCoded, String maxPrefixCoded) {
                            NumericRangeTermEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, NumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("valSize must be 32 or 64");
                }
            }
            this.next();
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            throw new UnsupportedOperationException("not implemented");
        }

        protected void setEnum(TermEnum tenum) {
            throw new UnsupportedOperationException("not implemented");
        }

        protected boolean termCompare(Term term) {
            return term.field() == NumericRangeQuery.this.field && term.text().compareTo(this.currentUpperBound) <= 0;
        }

        public boolean next() throws IOException {
            if (this.currentTerm != null) {
                assert (this.actualEnum != null);
                if (this.actualEnum.next()) {
                    this.currentTerm = this.actualEnum.term();
                    if (this.termCompare(this.currentTerm)) {
                        return true;
                    }
                }
            }
            this.currentTerm = null;
            while (this.rangeBounds.size() >= 2) {
                assert (this.rangeBounds.size() % 2 == 0);
                if (this.actualEnum != null) {
                    this.actualEnum.close();
                    this.actualEnum = null;
                }
                String lowerBound = this.rangeBounds.removeFirst();
                this.currentUpperBound = this.rangeBounds.removeFirst();
                this.actualEnum = this.reader.terms(this.termTemplate.createTerm(lowerBound));
                this.currentTerm = this.actualEnum.term();
                if (this.currentTerm != null && this.termCompare(this.currentTerm)) {
                    return true;
                }
                this.currentTerm = null;
            }
            assert (this.rangeBounds.size() == 0 && this.currentTerm == null);
            return false;
        }

        public void close() throws IOException {
            this.rangeBounds.clear();
            this.currentUpperBound = null;
            super.close();
        }
    }
}

