/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import io.airlift.bootstrap.LifeCycleManager;
import io.prestosql.plugin.localfile.LocalFileMetadata;
import io.prestosql.plugin.localfile.LocalFileRecordSetProvider;
import io.prestosql.plugin.localfile.LocalFileSplitManager;
import io.prestosql.plugin.localfile.LocalFileTransactionHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class LocalFileConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final LocalFileMetadata metadata;
    private final LocalFileSplitManager splitManager;
    private final LocalFileRecordSetProvider recordSetProvider;

    @Inject
    public LocalFileConnector(LifeCycleManager lifeCycleManager, LocalFileMetadata metadata, LocalFileSplitManager splitManager, LocalFileRecordSetProvider recordSetProvider) {
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return LocalFileTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

