/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.prestosql.plugin.localfile.LocalFileConnector;
import io.prestosql.plugin.localfile.LocalFileHandleResolver;
import io.prestosql.plugin.localfile.LocalFileModule;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class LocalFileConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "localfile";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new LocalFileHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), new LocalFileModule()});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(LocalFileConnector.class);
    }
}

