/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.password.file;

import com.google.common.base.Suppliers;
import io.prestosql.plugin.password.file.FileConfig;
import io.prestosql.plugin.password.file.PasswordStore;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.PasswordAuthenticator;
import java.io.File;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;

public class FileAuthenticator
implements PasswordAuthenticator {
    private final Supplier<PasswordStore> passwordStoreSupplier;

    @Inject
    public FileAuthenticator(FileConfig config) {
        File file = config.getPasswordFile();
        int cacheMaxSize = config.getAuthTokenCacheMaxSize();
        this.passwordStoreSupplier = Suppliers.memoizeWithExpiration(() -> new PasswordStore(file, cacheMaxSize), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Principal createAuthenticatedPrincipal(String user, String password) {
        if (!this.passwordStoreSupplier.get().authenticate(user, password)) {
            throw new AccessDeniedException("Invalid credentials");
        }
        return new BasicPrincipal(user);
    }
}

