/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.password.salesforce;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.escape.Escaper;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.xml.XmlEscapers;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.log.Logger;
import io.prestosql.plugin.password.Credential;
import io.prestosql.plugin.password.salesforce.SalesforceAuthenticationClient;
import io.prestosql.plugin.password.salesforce.SalesforceConfig;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.PasswordAuthenticator;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SalesforceBasicAuthenticator
implements PasswordAuthenticator {
    private static final Logger log = Logger.get(SalesforceBasicAuthenticator.class);
    private final Set<String> allowedOrganizations;
    private final HttpClient httpClient;
    private final LoadingCache<Credential, Principal> userCache;

    @Inject
    public SalesforceBasicAuthenticator(SalesforceConfig config, @SalesforceAuthenticationClient HttpClient httpClient) {
        this.allowedOrganizations = ImmutableSet.copyOf(config.getOrgSet());
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.userCache = CacheBuilder.newBuilder().maximumSize((long)config.getCacheSize()).expireAfterWrite(config.getCacheExpireDuration().toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.from(this::doLogin));
    }

    public Principal createAuthenticatedPrincipal(String username, String password) {
        try {
            return (Principal)this.userCache.getUnchecked((Object)new Credential(username, password));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), AccessDeniedException.class);
            throw e;
        }
    }

    private Principal doLogin(Credential credential) {
        Document xmlResponse;
        log.debug("Logging into Salesforce.");
        String username = credential.getUser();
        String password = credential.getPassword();
        String loginSoapMessage = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<env:Envelope xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\nxmlns:urn=\"urn:enterprise.soap.sforce.com\"\n   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\">\n <env:Header>\n     <urn:CallOptions>\n       <urn:client>presto</urn:client>\n     </urn:CallOptions>\n </env:Header>\n <env:Body>\n   <n1:login xmlns:n1=\"urn:partner.soap.sforce.com\">\n     <n1:username>%s</n1:username>\n     <n1:password>%s</n1:password>\n   </n1:login>\n </env:Body>\n</env:Envelope>\n";
        String apiVersion = "46.0";
        String loginUrl = "https://login.salesforce.com/services/Soap/u/";
        Escaper escaper = XmlEscapers.xmlContentEscaper();
        Request request = new Request.Builder().setUri(URI.create(loginUrl + apiVersion)).setHeader("Content-Type", "text/xml;charset=UTF-8").setHeader("SOAPAction", "login").setMethod("POST").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)String.format(loginSoapMessage, escaper.escape(username), escaper.escape(password)), (Charset)StandardCharsets.UTF_8)).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        if (response.getStatusCode() != 200) {
            throw new AccessDeniedException(String.format("Invalid response for login\n.%s", response.getBody()));
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlResponse = builder.parse(new InputSource(new StringReader(response.getBody())));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(String.format("Error parsing response: %s\n\tReceived error message: %s", response.getBody(), e.getMessage()));
        }
        SalesforceBasicAuthenticator.getElementValue(xmlResponse, "sessionId");
        String returnedOrg = SalesforceBasicAuthenticator.getElementValue(xmlResponse, "organizationId");
        if (!this.allowedOrganizations.equals(ImmutableSet.of((Object)"all")) && !this.allowedOrganizations.contains(returnedOrg.toLowerCase(Locale.US))) {
            throw new AccessDeniedException(String.format("Login successful, but for wrong Salesforce org.  Got %s, but expected a different org.", returnedOrg));
        }
        return new BasicPrincipal(username);
    }

    private static String getElementValue(Document document, String elementName) {
        NodeList nodeList = document.getElementsByTagName(elementName);
        if (nodeList.getLength() == 0) {
            throw new RuntimeException(String.format("Salesforce login response does not contain a '%s' entry", elementName));
        }
        if (nodeList.getLength() > 1) {
            throw new RuntimeException(String.format("Salesforce login response contains multiple '%s' entries", elementName));
        }
        String content = Strings.emptyToNull((String)nodeList.item(0).getTextContent());
        if (content == null) {
            throw new RuntimeException(String.format("Salesforce login response contains an empty '%s' entry", elementName));
        }
        return content;
    }
}

