/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.ClientMode;
import datomic.spy.memcached.DefaultConnectionFactory;
import datomic.spy.memcached.DefaultHashAlgorithm;
import datomic.spy.memcached.HashAlgorithm;
import datomic.spy.memcached.KetamaNodeKeyFormatter;
import datomic.spy.memcached.KetamaNodeLocator;
import datomic.spy.memcached.MemcachedNode;
import datomic.spy.memcached.NodeLocator;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KetamaConnectionFactory
extends DefaultConnectionFactory {
    private final KetamaNodeKeyFormatter.Format ketamaNodeKeyFormat;
    private Map<InetSocketAddress, Integer> weights;

    public KetamaConnectionFactory(ClientMode clientMode, int qLen, int bufSize, long opQueueMaxBlockTime) {
        super(clientMode, qLen, bufSize, DefaultHashAlgorithm.KETAMA_HASH);
        this.ketamaNodeKeyFormat = KetamaNodeKeyFormatter.Format.SPYMEMCACHED;
        this.weights = new HashMap<InetSocketAddress, Integer>();
    }

    public KetamaConnectionFactory(int qLen, int bufSize, long opQueueMaxBlockTime) {
        this(qLen, bufSize, opQueueMaxBlockTime, DefaultHashAlgorithm.KETAMA_HASH, KetamaNodeKeyFormatter.Format.SPYMEMCACHED, new HashMap<InetSocketAddress, Integer>());
    }

    public KetamaConnectionFactory(int qLen, int bufSize, long opQueueMaxBlockTime, HashAlgorithm hash, KetamaNodeKeyFormatter.Format nodeKeyFormat, Map<InetSocketAddress, Integer> weights) {
        super(qLen, bufSize, hash);
        this.ketamaNodeKeyFormat = nodeKeyFormat;
        this.weights = weights;
    }

    public KetamaConnectionFactory() {
        this(DEFAULT_CLIENT_MODE, 16384, 16384, DEFAULT_OP_QUEUE_MAX_BLOCK_TIME);
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new KetamaNodeLocator(nodes, this.getHashAlg(), this.getKetamaNodeKeyFormat(), this.getWeights());
    }

    public KetamaNodeKeyFormatter.Format getKetamaNodeKeyFormat() {
        return this.ketamaNodeKeyFormat;
    }

    public Map<InetSocketAddress, Integer> getWeights() {
        return this.weights;
    }
}

