/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.auth;

import datomic.spy.memcached.auth.PlainCallbackHandler;
import javax.security.auth.callback.CallbackHandler;

public class AuthDescriptor {
    private final String[] mechs;
    private final CallbackHandler cbh;
    private int authAttempts;
    private int allowedAuthAttempts;

    public AuthDescriptor(String[] m, CallbackHandler h) {
        this.mechs = m;
        this.cbh = h;
        this.authAttempts = 0;
        String authThreshhold = System.getProperty("net.spy.memcached.auth.AuthThreshold");
        this.allowedAuthAttempts = authThreshhold != null ? Integer.parseInt(authThreshhold) : -1;
    }

    public static AuthDescriptor typical(String u, String p) {
        return new AuthDescriptor(new String[]{"CRAM-MD5", "PLAIN"}, new PlainCallbackHandler(u, p));
    }

    public boolean authThresholdReached() {
        if (this.allowedAuthAttempts < 0) {
            return false;
        }
        if (this.authAttempts >= this.allowedAuthAttempts) {
            return true;
        }
        ++this.authAttempts;
        return false;
    }

    public String[] getMechs() {
        return this.mechs;
    }

    public CallbackHandler getCallback() {
        return this.cbh;
    }
}

