/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.auth;

import datomic.spy.memcached.MemcachedConnection;
import datomic.spy.memcached.MemcachedNode;
import datomic.spy.memcached.OperationFactory;
import datomic.spy.memcached.auth.AuthDescriptor;
import datomic.spy.memcached.auth.AuthThread;
import datomic.spy.memcached.compat.SpyObject;
import java.util.HashMap;
import java.util.Map;

public class AuthThreadMonitor
extends SpyObject {
    private final Map<Object, AuthThread> nodeMap = new HashMap<Object, AuthThread>();

    public synchronized void authConnection(MemcachedConnection conn, OperationFactory opFact, AuthDescriptor authDescriptor, MemcachedNode node) {
        this.interruptOldAuth(node);
        AuthThread newSASLAuthenticator = new AuthThread(conn, opFact, authDescriptor, node);
        this.nodeMap.put(node, newSASLAuthenticator);
    }

    public synchronized void interruptAllPendingAuth() {
        for (AuthThread toStop : this.nodeMap.values()) {
            if (!toStop.isAlive()) continue;
            this.getLogger().warn("Connection shutdown in progress - interrupting waiting authentication thread.");
            toStop.interrupt();
        }
    }

    private void interruptOldAuth(MemcachedNode nodeToStop) {
        AuthThread toStop = this.nodeMap.get(nodeToStop);
        if (toStop != null) {
            if (toStop.isAlive()) {
                this.getLogger().warn("Incomplete authentication interrupted for node " + nodeToStop);
                toStop.interrupt();
            }
            this.nodeMap.remove(nodeToStop);
        }
    }

    protected Map<Object, AuthThread> getNodeMap() {
        return this.nodeMap;
    }
}

