/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.compat.log;

import datomic.spy.memcached.compat.log.AbstractLogger;
import datomic.spy.memcached.compat.log.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
extends AbstractLogger {
    private final Logger logger;

    public SLF4JLogger(String name) {
        super(name);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(Level level, Object message, Throwable e) {
        if (level == null) {
            level = Level.FATAL;
        }
        switch (level) {
            case TRACE: {
                this.logger.trace(message.toString(), e);
                break;
            }
            case DEBUG: {
                this.logger.debug(message.toString(), e);
                break;
            }
            case INFO: {
                this.logger.info(message.toString(), e);
                break;
            }
            case WARN: {
                this.logger.warn(message.toString(), e);
                break;
            }
            case ERROR: {
                this.logger.error(message.toString(), e);
                break;
            }
            case FATAL: {
                this.logger.error(message.toString(), e);
                break;
            }
            default: {
                this.logger.error("Unhandled Logging Level: " + (Object)((Object)level) + " with log message: " + message.toString(), e);
            }
        }
    }
}

