/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.DeleteOperation;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

final class DeleteOperationImpl
extends OperationImpl
implements DeleteOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus DELETED = new OperationStatus(true, "DELETED", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private final String key;

    public DeleteOperationImpl(String k, OperationCallback cb) {
        super(cb);
        this.key = k;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Delete of %s returned %s", this.key, line);
        this.getCallback().receivedStatus(this.matchStatus(line, DELETED, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(b, "delete", this.key);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    public String toString() {
        return "Cmd: delete Key: " + this.key;
    }
}

