/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.tapmessage;

import datomic.spy.memcached.tapmessage.BaseMessage;
import datomic.spy.memcached.tapmessage.TapRequestFlag;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RequestMessage
extends BaseMessage {
    private boolean hasBackfill;
    private boolean hasVBucketList;
    private boolean hasVBucketCheckpoints;
    private boolean hasFlags;
    private List<TapRequestFlag> flagList = new LinkedList<TapRequestFlag>();
    private short[] vblist = new short[0];
    private String name;
    private long backfilldate = -1L;
    private Map<Short, Long> vBucketCheckpoints = new HashMap<Short, Long>();

    public RequestMessage() {
        this.name = UUID.randomUUID().toString();
        this.totalbody += this.name.length();
        this.keylength = (short)this.name.length();
    }

    public void setFlags(TapRequestFlag f) {
        if (!this.flagList.contains((Object)f)) {
            if (!this.hasFlags) {
                this.hasFlags = true;
                this.extralength = (byte)(this.extralength + 4);
                this.totalbody += 4;
            }
            if (f.equals((Object)TapRequestFlag.BACKFILL)) {
                this.hasBackfill = true;
                this.totalbody += 8;
            }
            if (f.equals((Object)TapRequestFlag.LIST_VBUCKETS) || f.equals((Object)TapRequestFlag.TAKEOVER_VBUCKETS)) {
                this.hasVBucketList = true;
                this.totalbody += 2;
            }
            if (f.equals((Object)TapRequestFlag.CHECKPOINT)) {
                this.hasVBucketCheckpoints = true;
                this.totalbody += 2;
            }
            this.flagList.add(f);
        }
    }

    public List<TapRequestFlag> getFlags() {
        return this.flagList;
    }

    public void setBackfill(long date) {
        this.backfilldate = date;
    }

    public void setVbucketlist(short[] vbs) {
        int oldSize = (this.vblist.length + 1) * 2;
        int newSize = (vbs.length + 1) * 2;
        this.totalbody += newSize - oldSize;
        this.vblist = vbs;
    }

    public void setvBucketCheckpoints(Map<Short, Long> vbchkpnts) {
        int oldSize = this.vBucketCheckpoints.size() * 10;
        int newSize = vbchkpnts.size() * 10;
        this.totalbody += newSize - oldSize;
        this.vBucketCheckpoints = vbchkpnts;
    }

    public void setName(String n) {
        if (n.length() > 65535) {
            throw new IllegalArgumentException("Tap name too long");
        }
        this.totalbody += n.length() - this.name.length();
        this.keylength = (short)n.length();
        this.name = n;
    }

    @Override
    public ByteBuffer getBytes() {
        ByteBuffer bb = ByteBuffer.allocate(24 + this.getTotalbody());
        bb.put(this.magic.getMagic());
        bb.put(this.opcode.getOpcode());
        bb.putShort(this.keylength);
        bb.put(this.extralength);
        bb.put(this.datatype);
        bb.putShort(this.vbucket);
        bb.putInt(this.totalbody);
        bb.putInt(this.opaque);
        bb.putLong(this.cas);
        if (this.hasFlags) {
            int flag = 0;
            for (int i = 0; i < this.flagList.size(); ++i) {
                flag |= this.flagList.get(i).getFlags();
            }
            bb.putInt(flag);
        }
        bb.put(this.name.getBytes());
        if (this.hasBackfill) {
            bb.putLong(this.backfilldate);
        }
        if (this.hasVBucketList) {
            bb.putShort((short)this.vblist.length);
            for (int i = 0; i < this.vblist.length; ++i) {
                bb.putShort(this.vblist[i]);
            }
        }
        if (this.hasVBucketCheckpoints) {
            bb.putShort((short)this.vBucketCheckpoints.size());
            for (Short vBucket : this.vBucketCheckpoints.keySet()) {
                bb.putShort(vBucket);
                bb.putLong(this.vBucketCheckpoints.get(vBucket));
            }
        }
        return (ByteBuffer)bb.flip();
    }
}

