/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.memory.MemoryConnector;
import io.prestosql.plugin.memory.MemoryHandleResolver;
import io.prestosql.plugin.memory.MemoryModule;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class MemoryConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "memory";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new MemoryHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MemoryModule(context.getTypeManager(), context.getNodeManager())});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(MemoryConnector.class);
    }
}

