/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.memory.MemoryConfig;
import io.prestosql.plugin.memory.MemoryDataFragment;
import io.prestosql.plugin.memory.MemoryMetadata;
import io.prestosql.plugin.memory.MemorySplit;
import io.prestosql.plugin.memory.MemoryTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.OptionalLong;
import javax.inject.Inject;

public final class MemorySplitManager
implements ConnectorSplitManager {
    private final int splitsPerNode;
    private final MemoryMetadata metadata;

    @Inject
    public MemorySplitManager(MemoryConfig config, MemoryMetadata metadata) {
        this.splitsPerNode = config.getSplitsPerNode();
        this.metadata = metadata;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle handle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        List<MemoryDataFragment> dataFragments = this.metadata.getDataFragments(table.getId());
        int totalRows = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (MemoryDataFragment dataFragment : dataFragments) {
            long rows = dataFragment.getRows();
            totalRows = (int)((long)totalRows + rows);
            if (table.getLimit().isPresent() && (long)totalRows > table.getLimit().getAsLong()) {
                splits.add((Object)new MemorySplit(table.getId(), 0, 1, dataFragment.getHostAddress(), rows -= (long)totalRows - table.getLimit().getAsLong(), OptionalLong.of(rows)));
                break;
            }
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new MemorySplit(table.getId(), i, this.splitsPerNode, dataFragment.getHostAddress(), rows, OptionalLong.empty()));
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

