/*
 * Copyright 2000-2013 Vaadin Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.sass.internal.expression.exception;

import com.vaadin.sass.internal.parser.LexicalUnitImpl;

public class ArithmeticException extends RuntimeException {
    public ArithmeticException(String errorMsg) {
        super(errorMsg);
    }

    public ArithmeticException(String error, LexicalUnitImpl term) {
        super(buildMessage(error, term));
    }

    private static String buildMessage(String message, LexicalUnitImpl term) {
        StringBuilder builder = new StringBuilder(message);

        builder.append(": \"");
        builder.append(term.toString());
        builder.append("\" [");
        builder.append(term.getLineNumber());
        builder.append(",");
        builder.append(term.getColumnNumber());
        builder.append("]");

        return builder.toString();
    }
}
