/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class AnyCatalogPermissionsRule {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> catalogRegex;

    public AnyCatalogPermissionsRule(Optional<Pattern> userRegex, Optional<Pattern> groupRegex, Optional<Pattern> catalogRegex) {
        this.userRegex = userRegex;
        this.groupRegex = groupRegex;
        this.catalogRegex = catalogRegex;
    }

    public boolean match(String user, Set<String> groups, String catalog) {
        return this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.catalogRegex.map(regex -> regex.matcher(catalog).matches()).orElse(true) != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyCatalogPermissionsRule that = (AnyCatalogPermissionsRule)o;
        return AnyCatalogPermissionsRule.patternEquals(this.userRegex, that.userRegex) && AnyCatalogPermissionsRule.patternEquals(this.groupRegex, that.groupRegex) && AnyCatalogPermissionsRule.patternEquals(this.catalogRegex, that.catalogRegex);
    }

    private static boolean patternEquals(Optional<Pattern> left, Optional<Pattern> right) {
        if (left.isEmpty() || right.isEmpty()) {
            return left.isEmpty() == right.isEmpty();
        }
        Pattern leftPattern = left.get();
        Pattern rightPattern = right.get();
        return leftPattern.pattern().equals(rightPattern.pattern()) && leftPattern.flags() == rightPattern.flags();
    }

    public int hashCode() {
        return Objects.hash(this.userRegex, this.groupRegex, this.catalogRegex);
    }
}

