/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import datomic.spy.memcached.MemcachedClient;
import datomic.spy.memcached.compat.SpyThread;
import datomic.spy.memcached.config.ClusterConfiguration;
import datomic.spy.memcached.config.ClusterConfigurationObserver;
import datomic.spy.memcached.config.NodeEndPoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ASGPoller
extends SpyThread {
    public static final long DEFAULT_POLL_INTERVAL = 60000L;
    private static final int MAX_RETRY_ATTEMPT = 20;
    private static final long RETRY_INTERVAL = 500L;
    private final String groupName;
    private final int port;
    private final MemcachedClient client;
    private List<ClusterConfigurationObserver> clusterConfigObservers = new ArrayList<ClusterConfigurationObserver>();
    private Date date = new Date();
    private long lastSuccessfulPoll = this.date.getTime();
    private int pollingErrorCount = 0;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    public ASGPoller(MemcachedClient client, String groupName, int port) {
        this(client, groupName, port, 60000L, false);
    }

    public ASGPoller(MemcachedClient client, String groupName, int port, long pollingInterval, final boolean useDaemonThreads) {
        this.groupName = groupName;
        this.client = client;
        this.port = port;
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(useDaemonThreads);
                return thread;
            }
        });
        this.setDaemon(useDaemonThreads);
        this.subscribeForClusterConfiguration(client.getConnection());
        this.scheduledExecutor.scheduleAtFixedRate(this, 0L, pollingInterval, TimeUnit.MILLISECONDS);
        int retryCount = 0;
        while (!client.isConfigurationInitialized()) {
            this.getLogger().info("Poller thread waiting for configuration to initialize, retryCount: " + retryCount);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted waiting for configuration to initialize", e);
            }
            if (retryCount >= 20 && !client.isConfigurationInitialized()) {
                throw new RuntimeException("Max retry attempt reached for configuration to initialize. Stopping the current poll cycle");
            }
            ++retryCount;
        }
        this.getLogger().info("Configuration intialized");
    }

    public void subscribeForClusterConfiguration(ClusterConfigurationObserver observer) {
        this.clusterConfigObservers.add(observer);
    }

    @Override
    public void run() {
        try {
            this.getLogger().info("Polling ASG " + this.groupName);
            AmazonEC2 ec2Client = AmazonEC2ClientBuilder.defaultClient();
            Filter filter = new Filter("tag:aws:autoscaling:groupName").withValues(new String[]{this.groupName});
            DescribeInstancesRequest request = new DescribeInstancesRequest().withFilters(new Filter[]{filter});
            DescribeInstancesResult result = ec2Client.describeInstances(request);
            ArrayList<NodeEndPoint> endpoints = new ArrayList<NodeEndPoint>();
            if (result != null) {
                List reservations = result.getReservations();
                while (result.getNextToken() != null) {
                    request.setNextToken(result.getNextToken());
                    result = ec2Client.describeInstances(request);
                    reservations.addAll(result.getReservations());
                }
                for (Reservation reservation : result.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        if (instance.getPrivateIpAddress() == null) continue;
                        endpoints.add(new NodeEndPoint(instance.getPrivateDnsName(), instance.getPrivateIpAddress(), this.port));
                    }
                }
            }
            ClusterConfiguration newClusterConfiguration = new ClusterConfiguration(System.currentTimeMillis(), endpoints);
            this.getLogger().info("Updating configuration:" + newClusterConfiguration);
            for (ClusterConfigurationObserver observer : this.clusterConfigObservers) {
                this.getLogger().info("Notifying observers about configuration change.");
                observer.notifyUpdate(newClusterConfiguration);
            }
            if (!this.client.isConfigurationInitialized()) {
                this.client.setIsConfigurtionInitialized(true);
            }
            this.pollingErrorCount = 0;
            this.lastSuccessfulPoll = this.date.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().error((Object)"Error encountered in the poller.", e);
            this.trackPollingError();
        }
    }

    private void trackPollingError() {
        ++this.pollingErrorCount;
        this.getLogger().info("Number of consecutive poller errors is " + Long.toString(this.pollingErrorCount) + ". Number of minutes since the last successful polling is " + Long.toString(this.date.getTime() - this.lastSuccessfulPoll));
    }

    public void shutdown() {
        this.scheduledExecutor.shutdownNow();
    }
}

