/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.MemcachedClientIF;
import datomic.spy.memcached.transcoders.Transcoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class BaseCacheMap<V>
implements Map<String, V> {
    private final String keyPrefix;
    private final Transcoder<V> transcoder;
    private final MemcachedClientIF client;
    private final int exp;

    public BaseCacheMap(MemcachedClientIF c, int expiration, String prefix, Transcoder<V> t) {
        this.keyPrefix = prefix;
        this.transcoder = t;
        this.client = c;
        this.exp = expiration;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private String getKey(String k) {
        return this.keyPrefix + k;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public V get(Object key) {
        V rv = null;
        try {
            rv = this.client.get(this.getKey((String)key), this.transcoder);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return rv;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return Collections.emptySet();
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> me : t.entrySet()) {
            this.client.set(this.getKey(me.getKey()), this.exp, me.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V rv = null;
        try {
            rv = this.get(key);
            this.client.delete(this.getKey((String)key));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return rv;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<V> values() {
        return Collections.emptySet();
    }

    @Override
    public V put(String key, V value) {
        V rv = this.get(key);
        this.client.set(this.getKey(key), this.exp, value);
        return rv;
    }
}

