/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.config;

import datomic.spy.memcached.config.NodeEndPoint;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class ClusterConfiguration {
    private long configVersion;
    private List<NodeEndPoint> cacheNodeEndPoints;

    public ClusterConfiguration(long configVersion, List<NodeEndPoint> cacheNodeEndPoints) {
        this.configVersion = configVersion;
        this.cacheNodeEndPoints = cacheNodeEndPoints;
    }

    public long getConfigVersion() {
        return this.configVersion;
    }

    public List<NodeEndPoint> getCacheNodeEndPoints() {
        return this.cacheNodeEndPoints;
    }

    public List<InetSocketAddress> getInetSocketAddresses() {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(this.cacheNodeEndPoints.size());
        for (NodeEndPoint endPoint : this.cacheNodeEndPoints) {
            addrs.add(endPoint.getInetSocketAddress());
        }
        return addrs;
    }

    public String toString() {
        StringBuilder nodeList = new StringBuilder("Version:" + this.configVersion + "  CacheNode List:");
        for (NodeEndPoint endPoint : this.cacheNodeEndPoints) {
            nodeList.append(" " + endPoint.getHostName() + ":" + endPoint.getPort());
        }
        return nodeList.toString();
    }
}

