/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.ops;

import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationStatus;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultiOperationCallback
implements OperationCallback {
    private OperationStatus mostRecentStatus = null;
    private final AtomicInteger remaining;
    protected final OperationCallback originalCallback;

    public MultiOperationCallback(OperationCallback original, int todo) {
        if (original instanceof MultiOperationCallback) {
            original = ((MultiOperationCallback)original).originalCallback;
        }
        this.originalCallback = original;
        this.remaining = new AtomicInteger(todo);
    }

    @Override
    public void complete() {
        if (this.remaining.decrementAndGet() == 0) {
            this.originalCallback.receivedStatus(this.mostRecentStatus);
            this.originalCallback.complete();
        }
    }

    @Override
    public void receivedStatus(OperationStatus status) {
        this.mostRecentStatus = status;
    }
}

