/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.ops;

public enum StatusCode {
    SUCCESS,
    ERR_NOT_FOUND,
    ERR_EXISTS,
    ERR_2BIG,
    ERR_INVAL,
    ERR_NOT_STORED,
    ERR_DELTA_BADVAL,
    ERR_NOT_MY_VBUCKET,
    ERR_UNKNOWN_COMMAND,
    ERR_NO_MEM,
    ERR_NOT_SUPPORTED,
    ERR_INTERNAL,
    ERR_BUSY,
    ERR_TEMP_FAIL,
    CANCELLED,
    INTERRUPTED,
    TIMEDOUT,
    ERR_CLIENT;


    public static StatusCode fromBinaryCode(int code) {
        switch (code) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return ERR_NOT_FOUND;
            }
            case 2: {
                return ERR_EXISTS;
            }
            case 3: {
                return ERR_2BIG;
            }
            case 4: {
                return ERR_INVAL;
            }
            case 5: {
                return ERR_NOT_STORED;
            }
            case 6: {
                return ERR_DELTA_BADVAL;
            }
            case 7: {
                return ERR_NOT_MY_VBUCKET;
            }
            case 129: {
                return ERR_UNKNOWN_COMMAND;
            }
            case 130: {
                return ERR_NO_MEM;
            }
            case 131: {
                return ERR_NOT_SUPPORTED;
            }
            case 132: {
                return ERR_INTERNAL;
            }
            case 133: {
                return ERR_BUSY;
            }
            case 134: {
                return ERR_TEMP_FAIL;
            }
        }
        return ERR_CLIENT;
    }

    public static StatusCode fromAsciiLine(String line) {
        if (line.equals("STORED") || line.equals("DELETED")) {
            return SUCCESS;
        }
        if (line.equals("NOT_STORED")) {
            return ERR_NOT_STORED;
        }
        if (line.equals("EXISTS")) {
            return ERR_EXISTS;
        }
        if (line.equals("NOT_FOUND")) {
            return ERR_NOT_FOUND;
        }
        if (line.equals("ERROR") || line.matches("^(CLIENT|SERVER)_ERROR.*")) {
            return ERR_INTERNAL;
        }
        return ERR_CLIENT;
    }
}

