/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.ops.FlushOperation;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;

final class FlushOperationImpl
extends OperationImpl
implements FlushOperation {
    private static final byte[] FLUSH = "flush_all\r\n".getBytes();
    private static final OperationStatus OK = new OperationStatus(true, "OK", StatusCode.SUCCESS);
    private final int delay;

    public FlushOperationImpl(int d, OperationCallback cb) {
        super(cb);
        this.delay = d;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Flush completed successfully");
        this.getCallback().receivedStatus(this.matchStatus(line, OK));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = null;
        if (this.delay == -1) {
            b = ByteBuffer.wrap(FLUSH);
        } else {
            b = ByteBuffer.allocate(32);
            b.put(("flush_all " + this.delay + "\r\n").getBytes());
            b.flip();
        }
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: flush_all Delay: " + this.delay;
    }
}

