/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.binary;

import datomic.spy.memcached.ConnectionFactory;
import datomic.spy.memcached.ops.CASOperation;
import datomic.spy.memcached.ops.GetOperation;
import datomic.spy.memcached.ops.Operation;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.StoreOperation;
import datomic.spy.memcached.protocol.ProxyCallback;
import datomic.spy.memcached.protocol.TCPMemcachedNodeImpl;
import datomic.spy.memcached.protocol.binary.OptimizedGetImpl;
import datomic.spy.memcached.protocol.binary.OptimizedSetImpl;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;

public class BinaryMemcachedNodeImpl
extends TCPMemcachedNodeImpl {
    private static final int MAX_GET_OPTIMIZATION_COUNT = 4096;
    private static final int MAX_SET_OPTIMIZATION_COUNT = 65535;
    private static final int MAX_SET_OPTIMIZATION_BYTES = 0x200000;

    public BinaryMemcachedNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, Long opQueueMaxBlockTimeNs, boolean waitForAuth, long defaultOpTimeout, long configOpTimeout, long at, ConnectionFactory fa) {
        super(sa, c, bufSize, rq, wq, iq, opQueueMaxBlockTimeNs, waitForAuth, defaultOpTimeout, configOpTimeout, at, fa);
    }

    @Override
    protected void optimize() {
        Operation firstOp = (Operation)this.writeQ.peek();
        if (firstOp instanceof GetOperation) {
            this.optimizeGets();
        } else if (firstOp instanceof CASOperation) {
            this.optimizeSets();
        }
    }

    private void optimizeGets() {
        this.optimizedOp = (Operation)this.writeQ.remove();
        if (this.writeQ.peek() instanceof GetOperation) {
            OptimizedGetImpl og = new OptimizedGetImpl((GetOperation)this.optimizedOp);
            this.optimizedOp = og;
            while (this.writeQ.peek() instanceof GetOperation && og.size() < 4096) {
                GetOperation o = (GetOperation)this.writeQ.remove();
                if (o.isCancelled()) continue;
                og.addOperation(o);
            }
            this.optimizedOp.initialize();
            assert (this.optimizedOp.getState() == OperationState.WRITE_QUEUED);
            ProxyCallback pcb = (ProxyCallback)og.getCallback();
            this.getLogger().debug("Set up %s with %s keys and %s callbacks", this, pcb.numKeys(), pcb.numCallbacks());
        }
    }

    private void optimizeSets() {
        this.optimizedOp = (Operation)this.writeQ.remove();
        if (this.writeQ.peek() instanceof CASOperation) {
            OptimizedSetImpl og = new OptimizedSetImpl((CASOperation)this.optimizedOp);
            this.optimizedOp = og;
            while (this.writeQ.peek() instanceof StoreOperation && og.size() < 65535 && og.bytes() < 0x200000) {
                CASOperation o = (CASOperation)this.writeQ.remove();
                if (o.isCancelled()) continue;
                og.addOperation(o);
            }
            this.optimizedOp.initialize();
            assert (this.optimizedOp.getState() == OperationState.WRITE_QUEUED);
        }
    }
}

