/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.binary;

import datomic.spy.memcached.ops.ConcatenationOperation;
import datomic.spy.memcached.ops.ConcatenationType;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.protocol.binary.SingleKeyOperationImpl;

class ConcatenationOperationImpl
extends SingleKeyOperationImpl
implements ConcatenationOperation {
    private static final int APPEND = 14;
    private static final int PREPEND = 15;
    private final long cas;
    private final ConcatenationType catType;
    private final byte[] data;

    private static byte cmdMap(ConcatenationType t) {
        byte rv;
        switch (t) {
            case append: {
                rv = 14;
                break;
            }
            case prepend: {
                rv = 15;
                break;
            }
            default: {
                rv = -1;
            }
        }
        assert (rv != -1) : "Unhandled store type:  " + (Object)((Object)t);
        return rv;
    }

    public ConcatenationOperationImpl(ConcatenationType t, String k, byte[] d, long c, OperationCallback cb) {
        super(ConcatenationOperationImpl.cmdMap(t), ConcatenationOperationImpl.generateOpaque(), k, cb);
        this.data = d;
        this.cas = c;
        this.catType = t;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, this.cas, this.data, new Object[0]);
    }

    @Override
    public long getCasValue() {
        return this.cas;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ConcatenationType getStoreType() {
        return this.catType;
    }

    @Override
    public String toString() {
        return super.toString() + " Cas: " + this.cas + " Data Length: " + this.data.length;
    }
}

