/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import java.util.Optional;

public class DuplicateMapKeyException
extends PrestoException {
    private final Block block;
    private final int position;
    private final boolean hasDetailedMessage;

    public DuplicateMapKeyException(Block block, int position) {
        this(block, position, Optional.empty());
    }

    private DuplicateMapKeyException(Block block, int position, Optional<String> detailedMessage) {
        super((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, detailedMessage.orElse("Duplicate map keys are not allowed"));
        this.block = block;
        this.position = position;
        this.hasDetailedMessage = detailedMessage.isPresent();
    }

    public DuplicateMapKeyException withDetailedMessage(Type keyType, ConnectorSession session) {
        if (this.hasDetailedMessage) {
            return this;
        }
        String detailedMessage = String.format("Duplicate map keys (%s) are not allowed", keyType.getObjectValue(session, this.block, this.position));
        return new DuplicateMapKeyException(this.block, this.position, Optional.of(detailedMessage));
    }
}

