/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class Constraint {
    private final TupleDomain<ColumnHandle> summary;
    private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;
    private final Optional<Set<ColumnHandle>> predicateColumns;

    public static Constraint alwaysTrue() {
        return new Constraint(TupleDomain.all(), Optional.empty(), Optional.empty());
    }

    public static Constraint alwaysFalse() {
        return new Constraint(TupleDomain.none(), Optional.of(bindings -> false), Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary) {
        this(summary, Optional.empty(), Optional.empty());
    }

    @Deprecated
    public Constraint(TupleDomain<ColumnHandle> summary, Predicate<Map<ColumnHandle, NullableValue>> predicate) {
        this(summary, Optional.of(predicate), Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Predicate<Map<ColumnHandle, NullableValue>> predicate, Set<ColumnHandle> predicateColumns) {
        this(summary, Optional.of(predicate), Optional.of(predicateColumns));
    }

    @Deprecated
    public Constraint(TupleDomain<ColumnHandle> summary, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        this(summary, predicate, Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate, Optional<Set<ColumnHandle>> predicateColumns) {
        this.summary = Objects.requireNonNull(summary, "summary is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        if (predicateColumns.isPresent() && predicate.isEmpty()) {
            throw new IllegalArgumentException("predicateColumns cannot be present when predicate is not present");
        }
    }

    public TupleDomain<ColumnHandle> getSummary() {
        return this.summary;
    }

    public Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate() {
        return this.predicate;
    }

    @Deprecated
    public Optional<Set<ColumnHandle>> getColumns() {
        return this.getPredicateColumns();
    }

    public Optional<Set<ColumnHandle>> getPredicateColumns() {
        return this.predicateColumns;
    }
}

