/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.NotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;

public class MaterializedViewNotFoundException
extends NotFoundException {
    private final SchemaTableName materializedViewName;

    public MaterializedViewNotFoundException(SchemaTableName materializedViewName) {
        this(materializedViewName, String.format("Materialized View '%s' not found", materializedViewName));
    }

    public MaterializedViewNotFoundException(SchemaTableName materializedViewName, String message) {
        super(message);
        this.materializedViewName = Objects.requireNonNull(materializedViewName, "materializedViewName is null");
    }

    public MaterializedViewNotFoundException(SchemaTableName materializedViewName, Throwable cause) {
        this(materializedViewName, String.format("Materialized View '%s' not found", materializedViewName), cause);
    }

    public MaterializedViewNotFoundException(SchemaTableName materializedViewName, String message, Throwable cause) {
        super(message, cause);
        this.materializedViewName = Objects.requireNonNull(materializedViewName, "viewName is null");
    }

    public SchemaTableName getMaterializedViewName() {
        return this.materializedViewName;
    }
}

