/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.Int128ArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.TypeOperatorDeclaration;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.lang.invoke.MethodHandles;

final class LongDecimalType
extends DecimalType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongDecimalType.class, MethodHandles.lookup(), Slice.class);

    LongDecimalType(int precision, int scale) {
        super(precision, scale, Slice.class);
        LongDecimalType.checkArgument(18 < precision && precision <= 38, "Invalid precision: %s", precision);
        LongDecimalType.checkArgument(0 <= scale && scale <= precision, "Invalid scale for precision %s: %s", precision, scale);
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = this.getSlice(block, position);
        return new SqlDecimal(Decimals.decodeUnscaledValue(slice), this.getPrecision(), this.getScale());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0));
            blockBuilder.writeLong(block.getLong(position, 8));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        blockBuilder.writeLong(value.getLong(offset));
        blockBuilder.writeLong(value.getLong(offset + 8));
        blockBuilder.closeEntry();
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return Slices.wrappedLongArray((long[])new long[]{block.getLong(position, 0), block.getLong(position, 8)});
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return LongDecimalType.equal(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongDecimalType.equal(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static boolean equal(long leftLow, long leftHigh, long rightLow, long rightHigh) {
        return leftLow == rightLow && leftHigh == rightHigh;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return LongDecimalType.xxHash64(value.getLong(0), value.getLong(8));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongDecimalType.xxHash64(block.getLong(position, 0), block.getLong(position, 8));
    }

    private static long xxHash64(long low, long high) {
        return XxHash64.hash((long)low) ^ XxHash64.hash((long)high);
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(Slice left, Slice right) {
        return UnscaledDecimal128Arithmetic.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        long leftLow = leftBlock.getLong(leftPosition, 0);
        long leftHigh = leftBlock.getLong(leftPosition, 8);
        long rightLow = rightBlock.getLong(rightPosition, 0);
        long rightHigh = rightBlock.getLong(rightPosition, 8);
        return UnscaledDecimal128Arithmetic.compare(leftLow, leftHigh, rightLow, rightHigh);
    }
}

