/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.TypeSignature;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NamedTypeSignature {
    private final Optional<RowFieldName> fieldName;
    private final TypeSignature typeSignature;

    public NamedTypeSignature(Optional<RowFieldName> fieldName, TypeSignature typeSignature) {
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName is null");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature is null");
    }

    public Optional<RowFieldName> getFieldName() {
        return this.fieldName;
    }

    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public Optional<String> getName() {
        return this.getFieldName().map(RowFieldName::getName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedTypeSignature other = (NamedTypeSignature)o;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.typeSignature, other.typeSignature);
    }

    public String toString() {
        if (this.fieldName.isPresent()) {
            return String.format("\"%s\" %s", this.fieldName.get().getName().replace("\"", "\"\""), this.typeSignature);
        }
        return this.typeSignature.toString();
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.typeSignature);
    }
}

