/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.type.AbstractIntType;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperatorDeclaration;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

public final class RealType
extends AbstractIntType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(RealType.class, MethodHandles.lookup(), Long.TYPE);
    public static final RealType REAL = new RealType();

    private RealType() {
        super(new TypeSignature("real", new TypeSignatureParameter[0]));
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(block.getInt(position, 0)));
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        int floatValue;
        try {
            floatValue = Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value (%sb) is not a valid single-precision float", Long.toBinaryString(value)));
        }
        blockBuilder.writeInt(floatValue).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == REAL;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.empty();
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) == Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        float realValue = Float.intBitsToFloat((int)value);
        if (realValue == 0.0f) {
            realValue = 0.0f;
        }
        return AbstractLongType.hash(Float.floatToIntBits(realValue));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        float realValue = Float.intBitsToFloat((int)value);
        if (realValue == 0.0f) {
            realValue = 0.0f;
        }
        return XxHash64.hash((long)Float.floatToIntBits(realValue));
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    private static boolean distinctFromOperator(long left, @IsNull boolean leftNull, long right, @IsNull boolean rightNull) {
        if (leftNull || rightNull) {
            return leftNull != rightNull;
        }
        float leftFloat = Float.intBitsToFloat((int)left);
        float rightFloat = Float.intBitsToFloat((int)right);
        if (Float.isNaN(leftFloat) && Float.isNaN(rightFloat)) {
            return false;
        }
        return leftFloat != rightFloat;
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(long left, long right) {
        return Float.compare(Float.intBitsToFloat((int)left), Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) < Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) <= Float.intBitsToFloat((int)right);
    }
}

