/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.util.List;

public class TimeParametricType
implements ParametricType {
    public static final TimeParametricType TIME = new TimeParametricType();

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return TimeType.TIME;
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for TIME");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("TIME precision must be a number");
        }
        long precision = parameter.getLongLiteral();
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid TIME precision " + precision);
        }
        return TimeType.createTimeType((int)precision);
    }
}

