/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.ByteArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperatorDeclaration;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

public final class TinyintType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(TinyintType.class, MethodHandles.lookup(), Long.TYPE);
    public static final TinyintType TINYINT = new TinyintType();

    private TinyintType() {
        super(new TypeSignature("tinyint", new TypeSignatureParameter[0]), Long.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getByte(position, 0);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(-128L, 127L));
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeByte(block.getByte(position, 0)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getByte(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > 127L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_BYTE", value));
        }
        if (value < -128L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_BYTE", value));
        }
        blockBuilder.writeByte((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == TINYINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash((byte)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)((byte)value));
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(long left, long right) {
        return Byte.compare((byte)left, (byte)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return (byte)left < (byte)right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return (byte)left <= (byte)right;
    }
}

