/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.type;

import io.prestosql.plugin.base.type.LongTimestampEncoder;
import io.prestosql.plugin.base.type.PrestoTimestampEncoder;
import io.prestosql.plugin.base.type.ShortTimestampEncoder;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampType;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public final class PrestoTimestampEncoderFactory {
    private PrestoTimestampEncoderFactory() {
    }

    public static PrestoTimestampEncoder<? extends Comparable<?>> createTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(timeZone, "timeZoneKey is null");
        if (type.isShort()) {
            return new ShortTimestampEncoder(type, timeZone);
        }
        return new LongTimestampEncoder(type, timeZone);
    }

    static LongTimestamp longTimestamp(long epochSecond, long fractionInPicos) {
        return new LongTimestamp(Math.multiplyExact(epochSecond, 1000000) + fractionInPicos / 1000000L, (int)(fractionInPicos % 1000000L));
    }
}

