/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropColumn
extends Statement {
    private final QualifiedName table;
    private final Identifier column;
    private final boolean tableExists;
    private final boolean columnExists;

    public DropColumn(QualifiedName table, Identifier column, boolean tableExists, boolean columnExists) {
        this(Optional.empty(), table, column, tableExists, columnExists);
    }

    public DropColumn(NodeLocation location, QualifiedName table, Identifier column, boolean tableExists, boolean columnExists) {
        this(Optional.of(location), table, column, tableExists, columnExists);
    }

    private DropColumn(Optional<NodeLocation> location, QualifiedName table, Identifier column, boolean tableExists, boolean columnExists) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableExists = tableExists;
        this.columnExists = columnExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getColumn() {
        return this.column;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnExists() {
        return this.columnExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropColumn that = (DropColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.column, that.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.column);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("column", (Object)this.column).toString();
    }
}

