/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public final class GenericLiteral
extends Literal {
    private final String type;
    private final String value;

    public GenericLiteral(String type, String value) {
        this(Optional.empty(), type, value);
    }

    public GenericLiteral(NodeLocation location, String type, String value) {
        this(Optional.of(location), type, value);
    }

    private GenericLiteral(Optional<NodeLocation> location, String type, String value) {
        super(location);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        if (type.equalsIgnoreCase("X")) {
            throw new ParsingException("Spaces are not allowed between 'X' and the starting quote of a binary literal", location.get());
        }
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericLiteral other = (GenericLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!GenericLiteral.sameClass(this, other)) {
            return false;
        }
        GenericLiteral otherLiteral = (GenericLiteral)other;
        return this.value.equals(otherLiteral.value) && this.type.equals(otherLiteral.type);
    }
}

