/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Preconditions;
import io.prestosql.sql.parser.CaseInsensitiveStream;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.type.TypeCalculationBaseVisitor;
import io.prestosql.type.TypeCalculationLexer;
import io.prestosql.type.TypeCalculationParser;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public final class TypeCalculation {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine + 1);
        }
    };

    private TypeCalculation() {
    }

    public static Long calculateLiteralValue(String calculation, Map<String, Long> inputs) {
        try {
            ParserRuleContext tree = TypeCalculation.parseTypeCalculation(calculation);
            CalculateTypeVisitor visitor = new CalculateTypeVisitor(inputs);
            BigInteger result = (BigInteger)visitor.visit((ParseTree)tree);
            return result.longValueExact();
        }
        catch (StackOverflowError e) {
            throw new ParsingException("Type calculation is too large (stack overflow while parsing)");
        }
    }

    private static ParserRuleContext parseTypeCalculation(String calculation) {
        TypeCalculationParser.TypeCalculationContext tree;
        TypeCalculationLexer lexer = new TypeCalculationLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)calculation)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        TypeCalculationParser parser = new TypeCalculationParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tree = parser.typeCalculation();
        }
        catch (ParseCancellationException ex) {
            tokenStream.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parser.typeCalculation();
        }
        return tree;
    }

    private static class CalculateTypeVisitor
    extends TypeCalculationBaseVisitor<BigInteger> {
        private final Map<String, Long> inputs;

        public CalculateTypeVisitor(Map<String, Long> inputs) {
            this.inputs = Objects.requireNonNull(inputs);
        }

        @Override
        public BigInteger visitTypeCalculation(TypeCalculationParser.TypeCalculationContext ctx) {
            return (BigInteger)this.visit((ParseTree)ctx.expression());
        }

        @Override
        public BigInteger visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            BigInteger left = (BigInteger)this.visit((ParseTree)ctx.left);
            BigInteger right = (BigInteger)this.visit((ParseTree)ctx.right);
            switch (ctx.operator.getType()) {
                case 4: {
                    return left.add(right);
                }
                case 5: {
                    return left.subtract(right);
                }
                case 6: {
                    return left.multiply(right);
                }
                case 7: {
                    return left.divide(right);
                }
            }
            throw new IllegalStateException("Unsupported binary operator " + ctx.operator.getText());
        }

        @Override
        public BigInteger visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            BigInteger value = (BigInteger)this.visit((ParseTree)ctx.expression());
            switch (ctx.operator.getType()) {
                case 4: {
                    return value;
                }
                case 5: {
                    return value.negate();
                }
            }
            throw new IllegalStateException("Unsupported unary operator " + ctx.operator.getText());
        }

        @Override
        public BigInteger visitBinaryFunction(TypeCalculationParser.BinaryFunctionContext ctx) {
            BigInteger left = (BigInteger)this.visit((ParseTree)ctx.left);
            BigInteger right = (BigInteger)this.visit((ParseTree)ctx.right);
            switch (ctx.binaryFunctionName().name.getType()) {
                case 9: {
                    return left.min(right);
                }
                case 10: {
                    return left.max(right);
                }
            }
            throw new IllegalArgumentException("Unsupported binary function " + ctx.binaryFunctionName().getText());
        }

        @Override
        public BigInteger visitNumericLiteral(TypeCalculationParser.NumericLiteralContext ctx) {
            return new BigInteger(ctx.INTEGER_VALUE().getText());
        }

        @Override
        public BigInteger visitNullLiteral(TypeCalculationParser.NullLiteralContext ctx) {
            return BigInteger.ZERO;
        }

        @Override
        public BigInteger visitIdentifier(TypeCalculationParser.IdentifierContext ctx) {
            String identifier = ctx.getText();
            Long value = this.inputs.get(identifier);
            Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is not specified in the inputs", (Object)identifier);
            return BigInteger.valueOf(value);
        }

        @Override
        public BigInteger visitParenthesizedExpression(TypeCalculationParser.ParenthesizedExpressionContext ctx) {
            return (BigInteger)this.visit((ParseTree)ctx.expression());
        }
    }

    private static class IsSimpleExpressionVisitor
    extends TypeCalculationBaseVisitor<Boolean> {
        private IsSimpleExpressionVisitor() {
        }

        @Override
        public Boolean visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            return false;
        }

        @Override
        public Boolean visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            return false;
        }

        protected Boolean defaultResult() {
            return true;
        }

        protected Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
            return aggregate != false && nextResult != false;
        }
    }
}

