/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.codec;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.DefaultVectorType;
import com.datastax.oss.driver.internal.core.type.codec.SimpleBlobCodec;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.OptionalCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.BooleanListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.ByteListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.DoubleListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.FloatListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.IntListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.LongListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.ObjectListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.ShortListToArrayCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.enums.EnumNameCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.enums.EnumOrdinalCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.json.JsonCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.time.LocalTimestampCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.time.PersistentZonedTimestampCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.time.TimestampMillisCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.time.ZonedTimestampCodec;
import com.datastax.oss.driver.internal.core.type.codec.extras.vector.FloatVectorToArrayCodec;
import com.datastax.oss.driver.shaded.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;

public class ExtraTypeCodecs {
    public static final TypeCodec<Instant> TIMESTAMP_UTC = new TimestampCodec(ZoneOffset.UTC);
    public static final PrimitiveLongCodec TIMESTAMP_MILLIS_SYSTEM = new TimestampMillisCodec();
    public static final PrimitiveLongCodec TIMESTAMP_MILLIS_UTC = new TimestampMillisCodec(ZoneOffset.UTC);
    public static final TypeCodec<ZonedDateTime> ZONED_TIMESTAMP_SYSTEM = new ZonedTimestampCodec();
    public static final TypeCodec<ZonedDateTime> ZONED_TIMESTAMP_UTC = new ZonedTimestampCodec(ZoneOffset.UTC);
    public static final TypeCodec<ZonedDateTime> ZONED_TIMESTAMP_PERSISTED = new PersistentZonedTimestampCodec();
    public static final TypeCodec<LocalDateTime> LOCAL_TIMESTAMP_SYSTEM = new LocalTimestampCodec();
    public static final TypeCodec<LocalDateTime> LOCAL_TIMESTAMP_UTC = new LocalTimestampCodec(ZoneOffset.UTC);
    public static final TypeCodec<byte[]> BLOB_TO_ARRAY = new SimpleBlobCodec();
    public static final TypeCodec<boolean[]> BOOLEAN_LIST_TO_ARRAY = new BooleanListToArrayCodec();
    public static final TypeCodec<byte[]> BYTE_LIST_TO_ARRAY = new ByteListToArrayCodec();
    public static final TypeCodec<short[]> SHORT_LIST_TO_ARRAY = new ShortListToArrayCodec();
    public static final TypeCodec<int[]> INT_LIST_TO_ARRAY = new IntListToArrayCodec();
    public static final TypeCodec<long[]> LONG_LIST_TO_ARRAY = new LongListToArrayCodec();
    public static final TypeCodec<float[]> FLOAT_LIST_TO_ARRAY = new FloatListToArrayCodec();
    public static final TypeCodec<double[]> DOUBLE_LIST_TO_ARRAY = new DoubleListToArrayCodec();

    @NonNull
    public static TypeCodec<Instant> timestampAt(@NonNull ZoneId timeZone) {
        return new TimestampCodec(timeZone);
    }

    @NonNull
    public static PrimitiveLongCodec timestampMillisAt(@NonNull ZoneId timeZone) {
        return new TimestampMillisCodec(timeZone);
    }

    @NonNull
    public static TypeCodec<ZonedDateTime> zonedTimestampAt(@NonNull ZoneId timeZone) {
        return new ZonedTimestampCodec(timeZone);
    }

    @NonNull
    public static TypeCodec<LocalDateTime> localTimestampAt(@NonNull ZoneId timeZone) {
        return new LocalTimestampCodec(timeZone);
    }

    @NonNull
    public static <T> TypeCodec<T[]> listToArrayOf(@NonNull TypeCodec<T> elementCodec) {
        return new ObjectListToArrayCodec<T>(elementCodec);
    }

    @NonNull
    public static <EnumT extends Enum<EnumT>> TypeCodec<EnumT> enumOrdinalsOf(@NonNull Class<EnumT> enumClass) {
        return new EnumOrdinalCodec<EnumT>(enumClass);
    }

    @NonNull
    public static <EnumT extends Enum<EnumT>> TypeCodec<EnumT> enumNamesOf(@NonNull Class<EnumT> enumClass) {
        return new EnumNameCodec<EnumT>(enumClass);
    }

    @NonNull
    public static <T> TypeCodec<Optional<T>> optionalOf(@NonNull TypeCodec<T> innerCodec) {
        return new OptionalCodec<T>(innerCodec);
    }

    @NonNull
    public static <T> TypeCodec<T> json(@NonNull GenericType<T> javaType) {
        return new JsonCodec<T>(javaType);
    }

    @NonNull
    public static <T> TypeCodec<T> json(@NonNull Class<T> javaType) {
        return new JsonCodec<T>(javaType);
    }

    @NonNull
    public static <T> TypeCodec<T> json(@NonNull GenericType<T> javaType, @NonNull ObjectMapper objectMapper) {
        return new JsonCodec<T>(javaType, objectMapper);
    }

    @NonNull
    public static <T> TypeCodec<T> json(@NonNull Class<T> javaType, @NonNull ObjectMapper objectMapper) {
        return new JsonCodec<T>(javaType, objectMapper);
    }

    public static TypeCodec<float[]> floatVectorToArray(int dimensions) {
        return new FloatVectorToArrayCodec(new DefaultVectorType(DataTypes.FLOAT, dimensions));
    }
}

