/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import io.prestosql.metadata.AllNodes;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.NodeState;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class NodeSystemTable
implements SystemTable {
    public static final SchemaTableName NODES_TABLE_NAME = new SchemaTableName("runtime", "nodes");
    public static final ConnectorTableMetadata NODES_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NODES_TABLE_NAME).column("node_id", (Type)VarcharType.createUnboundedVarcharType()).column("http_uri", (Type)VarcharType.createUnboundedVarcharType()).column("node_version", (Type)VarcharType.createUnboundedVarcharType()).column("coordinator", (Type)BooleanType.BOOLEAN).column("state", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final InternalNodeManager nodeManager;

    @Inject
    public NodeSystemTable(InternalNodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return NODES_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)NODES_TABLE);
        AllNodes allNodes = this.nodeManager.getAllNodes();
        this.addRows(table, allNodes.getActiveNodes(), NodeState.ACTIVE);
        this.addRows(table, allNodes.getInactiveNodes(), NodeState.INACTIVE);
        this.addRows(table, allNodes.getShuttingDownNodes(), NodeState.SHUTTING_DOWN);
        return table.build().cursor();
    }

    private void addRows(InMemoryRecordSet.Builder table, Set<InternalNode> nodes, NodeState state) {
        for (InternalNode node : nodes) {
            table.addRow(new Object[]{node.getNodeIdentifier(), node.getInternalUri().toString(), NodeSystemTable.getNodeVersion(node), this.isCoordinator(node), state.toString().toLowerCase(Locale.ENGLISH)});
        }
    }

    private static String getNodeVersion(InternalNode node) {
        return node.getNodeVersion().toString();
    }

    private boolean isCoordinator(InternalNode node) {
        return this.nodeManager.getCoordinators().contains(node);
    }
}

